<?php
// Test script to verify logging works
require_once __DIR__ . '/helpers/logger.php';

echo "Testing Logger...\n";
echo "Log file: " . Logger::getLogFile() . "\n\n";

// Test different log types
Logger::log("🧪 Test log message");
Logger::log("🧪 Test log with data", ['key' => 'value', 'number' => 123]);
Logger::logError("🧪 Test error");

// Test request logging
$_SERVER['REQUEST_METHOD'] = 'GET';
$_SERVER['REQUEST_URI'] = '/test.php?action=test';
$_SERVER['HTTP_USER_AGENT'] = 'TestScript/1.0';
$_SERVER['REMOTE_ADDR'] = '127.0.0.1';
$_SERVER['REQUEST_TIME_FLOAT'] = microtime(true);

Logger::logRequest();

echo "✅ Logging test completed. Check the log file.\n";