<?php
require_once __DIR__ . '/env.php';

class Database {
    private $host;
    private $db_name;
    private $username;
    private $password;
    private $conn;

    public function __construct() {
        $this->host = $_ENV['DB_HOST'] ?? getenv('DB_HOST');
        $this->db_name = $_ENV['DB_NAME'] ?? getenv('DB_NAME');
        $this->username = $_ENV['DB_USER'] ?? getenv('DB_USER');
        $this->password = $_ENV['DB_PASSWORD'] ?? getenv('DB_PASSWORD');
        
        error_log("🔧 Database Config - Host: {$this->host}, DB: {$this->db_name}, User: {$this->username}");
    }

    public function getConnection() {
        $this->conn = null;

        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4",
                $this->username,
                $this->password,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            error_log("✅ Database connection successful to: {$this->db_name}");
        } catch (PDOException $exception) {
            error_log("❌ Database connection failed: " . $exception->getMessage());
            die(json_encode([
                "error" => "Database connection failed", 
                "message" => $exception->getMessage()
            ]));
        }

        return $this->conn;
    }
}
?>