<?php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    exit(0);
}

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/middleware/jwtMiddleware.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Get user ID from JWT token
    $user_id = jwtMiddleware();
    
    echo json_encode([
        'success' => true,
        'debug' => [
            'user_id' => $user_id,
            
            // Get current user data
            'current_user' => $db->query("SELECT id, name, gender, preference, profile_complete, latitude, longitude FROM users WHERE id = $user_id")->fetch(PDO::FETCH_ASSOC),
            
            // Count all users except current
            'total_users_except_current' => $db->query("SELECT COUNT(*) as count FROM users WHERE id != $user_id")->fetch()['count'],
            
            // Count users with complete profiles
            'complete_profiles_except_current' => $db->query("SELECT COUNT(*) as count FROM users WHERE id != $user_id AND profile_complete = 1")->fetch()['count'],
            
            // Get all other users with details
            'all_other_users' => $db->query("SELECT id, name, gender, preference, profile_complete, latitude, longitude FROM users WHERE id != $user_id")->fetchAll(PDO::FETCH_ASSOC),
            
            // Check user photos
            'users_with_photos' => $db->query("
                SELECT u.id, u.name, COUNT(p.id) as photo_count 
                FROM users u 
                LEFT JOIN user_photos p ON u.id = p.user_id 
                WHERE u.id != $user_id 
                GROUP BY u.id
            ")->fetchAll(PDO::FETCH_ASSOC),
            
            // Check swipes
            'user_swipes' => $db->query("SELECT target_user_id, action FROM user_swipes WHERE user_id = $user_id")->fetchAll(PDO::FETCH_ASSOC),
            
            // Test the discovery query directly
            'discovery_test' => testDiscoveryQuery($db, $user_id),
            
            // Server info
            'server_time' => date('Y-m-d H:i:s'),
            'request_method' => $_SERVER['REQUEST_METHOD'],
            'query_params' => $_GET
        ]
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'trace' => $e->getTraceAsString()
    ]);
}

function testDiscoveryQuery($db, $current_user_id) {
    // Get current user
    $user_query = $db->prepare("SELECT * FROM users WHERE id = :user_id");
    $user_query->bindParam(':user_id', $current_user_id);
    $user_query->execute();
    $current_user = $user_query->fetch(PDO::FETCH_ASSOC);
    
    if (!$current_user) {
        return ['error' => 'Current user not found'];
    }
    
    // Test simplified query
    $query = "
        SELECT 
            u.id, u.name, u.age, u.bio, u.location,
            u.gender, u.preference,
            (SELECT photo_url FROM user_photos WHERE user_id = u.id ORDER BY RAND() LIMIT 1) as photo_url,
            (SELECT COUNT(*) FROM user_photos WHERE user_id = u.id) as total_photos
        FROM users u
        WHERE u.id != :current_user_id
        AND u.profile_complete = 1
        AND u.id NOT IN (SELECT target_user_id FROM user_swipes WHERE user_id = :current_user_id)
        LIMIT 10
    ";
    
    $stmt = $db->prepare($query);
    $stmt->bindParam(':current_user_id', $current_user_id);
    $stmt->execute();
    
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    return [
        'query' => $query,
        'params' => ['current_user_id' => $current_user_id],
        'results_count' => count($results),
        'results' => $results
    ];
}
?>