<?php
// Load environment variables from .env file
function loadEnv($filePath) {
    if (!file_exists($filePath)) {
        error_log("❌ .env file not found at: " . $filePath);
        return false;
    }

    $lines = file($filePath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0 || strpos($line, '=') === false) {
            continue;
        }

        list($name, $value) = explode('=', $line, 2);
        $name = trim($name);
        $value = trim($value);

        // Remove quotes if present
        if (preg_match('/^"(.+)"$/', $value, $matches)) {
            $value = $matches[1];
        } elseif (preg_match('/^\'(.+)\'$/', $value, $matches)) {
            $value = $matches[1];
        }

        if (!array_key_exists($name, $_ENV)) {
            $_ENV[$name] = $value;
            putenv("$name=$value");
        }
    }
    return true;
}

// Load .env file from root directory
$envFilePath = __DIR__ . '/../../.env';
$envLoaded = loadEnv($envFilePath);

if (!$envLoaded) {
    error_log("⚠️ Using default environment values");
    
    // Set default values
    $defaults = [
        'DB_HOST' => 'localhost',
        'DB_NAME' => 'tcligdfq_boonmate',
        'DB_USER' => 'tcligdfq_boonmate',
        'DB_PASSWORD' => 'tcligdfq_boonmate',
        'JWT_SECRET' => 'sakssam@4537saka',
        'JWT_EXPIRY' => '86400'
    ];
    
    foreach ($defaults as $key => $value) {
        if (!isset($_ENV[$key])) {
            $_ENV[$key] = $value;
            putenv("$key=$value");
        }
    }
}

// Verify required environment variables
$required = ['DB_HOST', 'DB_NAME', 'DB_USER', 'JWT_SECRET'];
foreach ($required as $key) {
    if (empty($_ENV[$key])) {
        error_log("❌ Missing required environment variable: $key");
        die(json_encode(["error" => "Server configuration error: Missing $key"]));
    }
}

error_log("✅ Environment configuration completed successfully");
?>